%This program is used to compute the ATS for independent cases by using 
%the proposed method of Shu and Jiang (2006).
%u0,s0 are the mean function and variance function estimated from IC data.
%u,s are the speicified mean function and variance function.
%delmin is a prameter denoting the minimum shift size
%h is the control limit
%m out of n is the sampling rate

function [ats,count]=ATS_D_adaptive(u0,s0,u,s,h,m,n,delmin)
L=length(u0);
lambda=0.1;
ATS0=100;
for i=1:ceil(L/n)
    A=randperm(n);
    B(((i-1)*m+1):((i-1)*m+m))=(i-1)*n+sort(A(1:m));
end
% B(1)=1;
B(ceil(L/n)*m+1)=L+1;
T=B(1);
count=1;
x=normrnd(u(T),s(T));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Qn=max(delmin,(1-lambda)*delmin+lambda*(x-u0(T))/s0(T));
hQn=log(1+2*(Qn/2)^2*ATS0*m/n+2.332*Qn/2)/Qn-1.166;
Cn=max(0,((x-u0(T))/s0(T)-Qn/2)/hQn);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
while (Cn<=h && T<=L)
    T=B(count+1);
if T>=L+1
    ats=T;
    break
else
x=normrnd(u(T),s(T));
count=count+1;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Qn=max(delmin,(1-lambda)*Qn+lambda*(x-u0(T))/s0(T));
hQn=log(1+2*(Qn/2)^2*ATS0*m/n+2.332*Qn/2)/Qn-1.166;
Cn=max(0,Cn+((x-u0(T))/s0(T)-Qn/2)/hQn);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end
end
if T>=L+1
    ats=T;
else
ats=T-B(1);
end
